'use strict';

define('bitbucket-plugin-tag/internal/feature/tags/commit-list/commit-list', ['@atlassian/aui', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/model/page-state', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/internal/util/history'], function (AJS, $, _, navBuilder, pageState, RevisionReference, ajax, events, history) {
    'use strict';

    function getCommitIds(commitRows) {
        return _.map(commitRows, function (row) {
            //data-commitid is specified in commits-table-clientside.soy, bitbucket.internal.feature.commits.commitsTableClientside.commitsTableRow
            return $(row).data('commitid');
        });
    }

    function getTagsUrl(project, repository) {
        return navBuilder.rest('tags').addPathComponents('projects', project.getKey(), 'repos', repository.getSlug(), 'tags').build();
    }

    function fetchTags(commitRows) {
        var project = pageState.getProject();
        var repository = pageState.getRepository();

        ajax.rest({
            data: getCommitIds(commitRows),
            type: 'POST', //POST to support an arbitrary number of commit IDs (each ID being 40 characters)
            url: getTagsUrl(project, repository)
        }).done(function (page) {
            if (page.values) {
                var tagsByCommitId = _.groupBy(page.values, 'latestCommit');
                _.forEach(tagsByCommitId, function (tags, commitId) {
                    commitRows.filter('[data-commitid=' + commitId + ']').addClass('has-tags').find('.message').append(bitbucketPluginTag.internal.feature.tags.commitList.commitList.panel({
                        project: project,
                        repository: repository,
                        tags: _.sortBy(tags)
                    }));
                });

                commitRows.find('.tag').tooltip({
                    delayIn: 0,
                    gravity: 'n',
                    hoverable: false,
                    html: true,
                    live: false,
                    title: function title() {
                        var refNames = $(this).attr('data-names');

                        return _.map(refNames.split(':'), AJS.escapeHtml).join('<br>');
                    }
                });
            }
        });
    }

    return {
        onReady: function onReady() {
            var $commitsTable = $('#commits-table');

            // fetch tags for any commit already in the page
            fetchTags($commitsTable.find('.commit-row'));

            // register a handler to populate the tags of the commits fetched by AJAX
            events.on('bitbucket.internal.DO_NOT_USE.widget.commitsTable.contentAdded', function (page) {
                fetchTags(page.values);
            });

            // use push-state API to transition between tags
            $commitsTable.on('click', '.tags-container .tag a', function (e) {
                e.preventDefault();
                var $tag = $(this);
                var revisionRef = new RevisionReference({
                    id: $tag.attr('data-id'),
                    displayId: $tag.text(),
                    latestCommit: $tag.attr('data-commit-id'),
                    type: RevisionReference.type.TAG
                });
                history.pushState(revisionRef.toJSON(), null, $tag.attr('href'));
            });
        }
    };
});