// Custom JS for Azure AD directory edit page
document.addEventListener('DOMContentLoaded', function () {

    // group filtering
    var groupFilteringEnabledCheckbox = $('#configure-azuread-form-groupFilteringEnabled');
    groupFilteringEnabledCheckbox.on('change', function (event) {
        $('#configure-azuread-form-incrementalSyncEnabled').prop('disabled', event.target.checked);
        $('#configure-azuread-form-filteredGroupNames').prop('disabled', !event.target.checked);
    });
    groupFilteringEnabledCheckbox.trigger('change')

    // textareas auto grow
    var growers = document.querySelectorAll(".grow-wrap");
    growers.forEach(function (grower) {
        var textarea = grower.querySelector("textarea");
        textarea.addEventListener("input", function () {
            grower.dataset.replicatedValue = textarea.value;
        });
        textarea.dispatchEvent(new Event("input"));
    });

    // convert filtered group names to multiline
    $('#configure-azuread-form-filteredGroupNames').on('change', function () {
        var text = $(this).val();
        var splitText = text.split('\n').filter(function(item) {
            return item!= null && item !== '';
        });
        $(this).val(splitText.join('\n'))
        $(this).get(0).dispatchEvent(new Event("input"))
    });

    // azure ad region selection
    var region = $("#configure-azuread-form-region")
    region.on("change init", function (event) {
        var graphEndpoint = document.querySelector("#configure-azuread-form-graphEndpoint");
        var authorityEndpoint = document.querySelector("#configure-azuread-form-authorityEndpoint");
        var region = event.target.value;
        var option = event.target.options[event.target.selectedIndex];
        if (!(event.type === 'init' && region === "CUSTOM")) {
            graphEndpoint.value = option.dataset.graphapiurl;
            authorityEndpoint.value = option.dataset.basicauthorityapiurl;
        }
        graphEndpoint.readOnly = authorityEndpoint.readOnly = region !== "CUSTOM";
    })
    region.trigger("init");

    // sync frequency
    var syncScheduleTypeRadios = document.getElementsByName("syncScheduleType");
    syncScheduleTypeRadios.forEach(function (radio) {
            radio.addEventListener("change", function () {
                var interval = document.querySelector("#configure-azuread-form-pollingIntervalInMin");
                var cron = document.querySelector("#configure-azuread-form-cronExpression");
                interval.disabled = this.id !== "syncScheduleTypeIntervalMins";
                cron.disabled = this.id !== "syncScheduleTypeCronExpr";
                // trigger change event to update the future schedules
                if (this.id === "syncScheduleTypeIntervalMins") {
                    interval.dispatchEvent(new Event("change"));
                } else {
                    cron.dispatchEvent(new Event("change"));
                }
            });
        }
    );

    // update future schedules
    $('#configure-azuread-form-cronExpression,#configure-azuread-form-pollingIntervalInMin').on("change", function (event) {
        var futureSchedule = $("#sync-frequency-future-schedule ul");

        // determine context path
        if (AJS.General) {
            path = AJS.General.getContextPath();
        } else if (AJS.contextPath) {
            path = AJS.contextPath();
        } else if (contextPath) {
            path = contextPath;
        }

        // clear textarea and show spinner if request takes longer than 500ms
        var showSpinner = setTimeout(function () {
            futureSchedule.empty();
            $('#scheduleLoading').prop("hidden", false)
        }, 500);

        $.ajax({
            url: path + '/rest/crowd/1/scheduler/future-schedules',
            "dataType": "json",
            method: 'GET',
            data: {
                "scheduleType": event.target.id === "configure-azuread-form-cronExpression" ? "CRON_EXPRESSION" : "INTERVAL",
                "expression": event.target.value,
                "numberOfFutureSchedules": 10
            },
            success: function (data) {
                clearTimeout(showSpinner);
                futureSchedule.empty();
                $('#scheduleLoading').prop("hidden", true)
                $.each(data, function (index, value) {
                    futureSchedule.append('<li>' + value + '</li>');
                });
            }
        });
    });

    // select the correct sync frequency type and trigger change event to update the future schedules
    if ($('#syncScheduleTypeCronExpr').is(":checked"))
        $('#syncScheduleTypeCronExpr').get(0).dispatchEvent(new Event('change'))
    else if ($('#syncScheduleTypeIntervalMins').length)
        $('#syncScheduleTypeIntervalMins').get(0).dispatchEvent(new Event('change'))
});