define('bitbucket-plugin-ssh/internal/views/keys/ssh-keys-table', [
    'bitbucket/internal/util/object',
    'bitbucket/internal/widget/paged-table/paged-table',
    'exports',
], function (obj, PagedTable, exports) {
    'use strict';

    function SshKeyTable(username, options) {
        this.username = username;
        this.restKeysBuilder = options.restKeysBuilder;
        PagedTable.call(this, options);
    }
    obj.inherits(SshKeyTable, PagedTable);

    SshKeyTable.prototype.buildUrl = function (start, limit) {
        var builder = this.restKeysBuilder().withParams({
            avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({
                size: 'xsmall',
            }),
            start: start,
            limit: limit,
        });

        if (this.username) {
            builder = builder.withParams({ user: this.username });
        }

        return builder.build();
    };

    SshKeyTable.prototype.handleNewRows = function (keyPage, attachmentMethod) {
        var self = this;

        var rows = bitbucketPluginSsh.internal.views.keys.sshKeysTable.keyRows({
            keys: keyPage.values,
        });

        this.$table.find('tbody')[attachmentMethod](rows);
    };

    exports.SshKeyTable = SshKeyTable;
});
