(function () {
    'use strict';

    let w = window;

    const wrm = w.WRM;

    let contribInstallers = 0;
    let contribInstalls = 0;
    let collectorInstaller = null;
    function tryInstallCollector() {
        if (contribInstallers === contribInstalls && collectorInstaller) {
            collectorInstaller();
            collectorInstaller = null;
        }
    }
    const api = {
        install(installer) {
            contribInstallers += 1;
            installer(() => {
                contribInstalls += 1;
                tryInstallCollector();
            });
        },
    };
    w["browser-metrics-plugin"] = api;
    wrm.require(["wrc!browser-metrics-plugin.contrib"], () => {
        w.require(["internal/browser-metrics-plugin/collector"], (collector) => {
            collectorInstaller = () => {
                collector.install();
            };
            tryInstallCollector();
        });
    });

})();
