(function () {
    'use strict';

    if ("PerformanceObserver" in window) {
        const observerBuffer = [];
        // @ts-expect-error typescript doesnt like assignments to window
        window.__observedResources = observerBuffer;
        const getType = (initiatorType) => {
            return initiatorType === 'script' ? 'script' : 'css';
        };
        const observer = new PerformanceObserver(list => {
            list.getEntries()
                .filter(({ initiatorType, name }) => {
                const isValidType = initiatorType === 'script' || isStylesheet(initiatorType, name);
                const hasSameOrigin = new URL(location.href).origin === new URL(name).origin;
                return isValidType && hasSameOrigin;
            })
                .forEach(({ name, transferSize, encodedBodySize, initiatorType }) => {
                observerBuffer.push([transferSize, encodedBodySize, name, getType(initiatorType)]);
            });
        });
        observer.observe({ type: 'resource' });
    }
    const isStylesheet = (type, name) => {
        return type === 'link' && name.split('.').pop() === 'css';
    };

})();
