define('bitbucket-plugin-code-insights/internal/page/settings/components/merge-check-settings-table', ['exports', '@atlassian/aui', 'react', 'bitbucket-plugin-code-insights/internal/page/settings/components/merge-check-settings-row', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/enums', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (exports, _aui, _react, _mergeCheckSettingsRow, _spinner, _enums, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.MergeCheckSettingsTable = MergeCheckSettingsTable;

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var getInsightsUrlBuilder = function getInsightsUrlBuilder(scopeType) {
        var url = nav.rest('insights');

        if (scopeType === _enums.ScopeType.REPOSITORY) {
            url = url.repository(_state2.default.getRepository());
        } else if (scopeType === _enums.ScopeType.PROJECT) {
            url = url.project(_state2.default.getProject());
        }

        return url;
    };

    function saveSetting(setting, scopeType) {
        var url = getInsightsUrlBuilder(scopeType);

        return (0, _server.rest)({
            url: url.addPathComponents('merge-check', setting.reportKey).build(),
            type: _server.method.PUT,
            data: setting
        });
    }

    function removeSettings(reportKey, scopeType) {
        var url = getInsightsUrlBuilder(scopeType);

        return (0, _server.rest)({
            url: url.addPathComponents('merge-check', reportKey).build(),
            type: _server.method.DELETE
        });
    }

    function MergeCheckSettingsTable(_ref) {
        var settings = _ref.settings,
            inheritedSettings = _ref.inheritedSettings,
            scopeType = _ref.scopeType,
            inheritUrl = _ref.inheritUrl;

        var _useState = (0, _react.useState)(settings),
            _useState2 = _slicedToArray(_useState, 2),
            mergeCheckSettings = _useState2[0],
            updateSettings = _useState2[1];

        var _useState3 = (0, _react.useState)(false),
            _useState4 = _slicedToArray(_useState3, 2),
            isSaving = _useState4[0],
            updateSaving = _useState4[1];

        function onAdd(setting) {
            updateSaving(true);
            saveSetting(setting, scopeType).then(function () {
                updateSettings(_extends(_defineProperty({}, setting.reportKey, setting), mergeCheckSettings));
            }).always(function () {
                return updateSaving(false);
            });
        }

        function onRemove(reportKey) {
            removeSettings(reportKey, scopeType).then(function () {
                delete mergeCheckSettings[reportKey];
                updateSettings(_extends({}, mergeCheckSettings));
            });
        }

        function generateRows(settings, inheritUrl) {
            return Object.keys(settings).sort().map(function (key) {
                return _react2.default.createElement(_mergeCheckSettingsRow.TableRow, {
                    key: key,
                    reportKey: key,
                    mustPass: settings[key].mustPass,
                    minProhibitedSeverity: settings[key].minProhibitedSeverity || _mergeCheckSettingsRow.SeverityCodes.ALLOW_ALL,
                    removeSetting: onRemove,
                    isInherited: settings[key].scope && settings[key].scope.type !== scopeType,
                    inheritUrl: inheritUrl
                });
            });
        }

        return _react2.default.createElement(
            'form',
            { className: 'aui' },
            _react2.default.createElement(
                'h3',
                null,
                _aui.I18n.getText('bitbucket.codeinsights.mergecheck.table.title')
            ),
            _react2.default.createElement(
                'table',
                { className: 'aui code-insights-merge-check-settings' },
                _react2.default.createElement(
                    'thead',
                    null,
                    _react2.default.createElement(
                        'tr',
                        null,
                        _react2.default.createElement(
                            'th',
                            { className: 'long', id: 'report-key' },
                            _aui.I18n.getText('bitbucket.codeinsights.mergecheck.table.column.reportkey')
                        ),
                        _react2.default.createElement(
                            'th',
                            { className: 'medium', id: 'requires-non-failing' },
                            _aui.I18n.getText('bitbucket.codeinsights.mergecheck.table.column.mustpass')
                        ),
                        _react2.default.createElement(
                            'th',
                            { className: 'medium', id: 'min-disallowed-sevs' },
                            _aui.I18n.getText('bitbucket.codeinsights.mergecheck.table.column.severity')
                        ),
                        _react2.default.createElement('th', { className: 'short actions', id: 'actions' })
                    )
                ),
                _react2.default.createElement(
                    'tbody',
                    null,
                    _react2.default.createElement(_mergeCheckSettingsRow.AddSettingRow, { onAdd: onAdd, settings: mergeCheckSettings }),
                    isSaving && _react2.default.createElement(
                        'tr',
                        null,
                        _react2.default.createElement(
                            'td',
                            { colSpan: 4 },
                            _react2.default.createElement(
                                'div',
                                { className: 'spinner-row' },
                                _react2.default.createElement(_spinner2.default, null)
                            )
                        )
                    ),
                    mergeCheckSettings && generateRows(mergeCheckSettings),
                    inheritedSettings && generateRows(inheritedSettings, inheritUrl)
                )
            )
        );
    }
});