define('diagnostics/date-range',
    [
        'jquery'
    ],
    function($) {
        'use strict';

        var DEFAULT_SELECTION = {
            payload: {}
        };
        var MONTH_NAMES = ["January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];

        function toDate(timeStamp) {
            if (timeStamp) {
                var date = new Date(timeStamp);
                return date.getDate() + '-' + MONTH_NAMES[date.getMonth()] + '-' + (date.getFullYear() + "").substring(2)
            }
            return null;
        }

        /**
         * @param {int} id
         * @param {String} label
         * @param {Function} onChangedFunction
         * @param {boolean} isSelected
         * @param {Object} selection
         *
         * @return {jQuery} date range picker
         */
        return function(id, label, onChangedFunction, isSelected, selection) {
            var dropdownId = id + '-dropdown';
            var dateSelection = selection.id === id ? selection : DEFAULT_SELECTION; // if we are the item selected, keep the data


            $('#' + dropdownId).remove();

            var $customDateTrigger = $(diagnostics.alertReport.customDateSpan({
                dropdownId: dropdownId,
                label: label,
                isSelected: isSelected
            }));

            var $dropdown = $(diagnostics.alertReport.customDateSpanDropdown({
                id: dropdownId,
                from: toDate(dateSelection.payload.from) || '',
                to: toDate(dateSelection.payload.to) || ''
            }));

            var $dateFrom = $dropdown.find('#dateFrom');
            var $dateTo = $dropdown.find('#dateTo');
            var $clear = $dropdown.find('#clear');

            var $dpFrom = $dateFrom
                .datePicker({ 'overrideBrowserDefault': true, dateFormat: "d-MM-y" });
            var $dpTo = $dateTo
                .datePicker({ 'overrideBrowserDefault': true, dateFormat: "d-MM-y" });

            var close = function() {
                $dpFrom.hide();
                $dpTo.hide();
                document.getElementById(dropdownId).open = false;
            };

            $dateFrom.on('change', function() {
                // Move to the next field
                $dpFrom.hide();
                $dpTo.show();
            });

            $dateTo.on('change', function() {
                // Apply (if dates are valid)
                var from = $dpFrom.getDate();
                from.setHours(0, 0, 1); // this sets this date to be firmly in this day, rather than being in the day before at midnight

                var to = $dpTo.getDate();
                to.setHours(23, 59, 59);

                if ($dateFrom.val()) {
                    onChangedFunction(id, from.getTime(), to.getTime());
                    close();
                }
            });

            $clear.click(function(e) {
                e.preventDefault();
                $dateFrom.val("");
                $dateTo.val("");
            });

            $dropdown.find('#close').on('click', function(e) {
                e.preventDefault();
                close();

                if (isSelected && (!$dateFrom.val() || !$dateTo.val())) {
                    onChangedFunction(undefined, undefined, undefined);
                }
            });

            return $customDateTrigger.add($dropdown)
        };


    }
);
