define('diagnostics/field-filter',
    [
        'jquery'
    ],
    function($) {
        'use strict';

        /**
         * @param {jQuery|HTMLElement} $elem
         * @param {jQuery|HTMLElement} $triggerElem
         * @param {Function} onChangedFunction
         * @param {boolean} sort
         * @param {Array} values
         */
        function FieldFilter($elem, $triggerElem, onChangedFunction, sort, values) {
            var self = this;

            this.$elem = $($elem);
            this.$triggerElem = $($triggerElem);
            this.label = this.$triggerElem.text();
            this.onChanged = onChangedFunction;
            this.fields = [];
            this.sort = sort !== undefined ? sort : true;

            this.$elem.on({
                "aui-dropdown2-item-check": function(event) {
                    self.toggle(event.target.getAttribute('key'));
                },
                "aui-dropdown2-item-uncheck": function(event) {
                    self.toggle(event.target.getAttribute('key'));
                }
            });

            if (values) {
                values.forEach(function(key) {this.addValue(key)}.bind(this));
            }
        }

        FieldFilter.prototype.addValue = function(key, label) {
            this.fields.push({
                selected: false,
                key: key,
                label: label || key
            });

            // Sort after insertion
            if (this.sort) {
                this.fields.sort(function(a, b) {
                    return a.label.localeCompare(b.label);
                })
            }
        };

        FieldFilter.prototype.getLabel = function() {
            var result = this.fields.filter(function (field) {
                    return field.selected;
                }).map(function(field) {
                    return field.label
                }).join(", ");

            return result === "" ? this.label : result;
        };

        FieldFilter.prototype.render = function() {
            this.$elem.find("ul").replaceWith(diagnostics.fieldFilter({
                values: this.fields
            }));
        };

        FieldFilter.prototype.toggle = function(value) {
            this.fields.forEach(function(field) {
                if (field.key === value) {
                    field.selected = !field.selected;
                }
            });

            this.onChanged();
            this.$triggerElem.text(this.getLabel());
        };

        FieldFilter.prototype.getSelected = function() {
            return this.fields.filter(function(field) {
                    return field.selected;
                }).map(function(field) {
                    return field.key;
                });
        };

        return FieldFilter;
    }
);
