define('diagnostics/relative-date',
    [
        'jquery'
    ],
    function($) {
        'use strict';

        /**
         * @param {int} id
         * @param {String} label
         * @param {int} relativeTime
         * @param {boolean} selected
         * @return {jQuery} relative time button
         **/
        return function(id, label, relativeTime, isSelected) {
            return $(diagnostics.alertReport.relativeDate({
                id: id,
                label: label,
                relativeTime: relativeTime,
                isSelected: isSelected
            }));
        }
    }
);
